package ru.yandex.partner.hourglass.configuration.property;

import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

@Component
@ConfigurationProperties("async-http-client")
public class AsyncHttpClientProperty {
    private int requestTimeout;
    private int readTimeout;
    private int connectionTimeout;
    private int connectionTtl;
    private int pooledConnectionIdleTimeout;
    private int threadsCount;

    public int getRequestTimeout() {
        return requestTimeout;
    }

    public void setRequestTimeout(int requestTimeout) {
        this.requestTimeout = requestTimeout;
    }

    public int getReadTimeout() {
        return readTimeout;
    }

    public void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
    }

    public int getConnectionTimeout() {
        return connectionTimeout;
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public int getConnectionTtl() {
        return connectionTtl;
    }

    public void setConnectionTtl(int connectionTtl) {
        this.connectionTtl = connectionTtl;
    }

    public int getPooledConnectionIdleTimeout() {
        return pooledConnectionIdleTimeout;
    }

    public void setPooledConnectionIdleTimeout(int pooledConnectionIdleTimeout) {
        this.pooledConnectionIdleTimeout = pooledConnectionIdleTimeout;
    }

    public int getThreadsCount() {
        return threadsCount;
    }

    public void setThreadsCount(int threadsCount) {
        this.threadsCount = threadsCount;
    }

    @Override
    public String toString() {
        return "AsyncHttpClientProperty{" +
                "requestTimeout=" + requestTimeout +
                ", readTimeout=" + readTimeout +
                ", connectionTimeout=" + connectionTimeout +
                ", connectionTtl=" + connectionTtl +
                ", pooledConnectionIdleTimeout=" + pooledConnectionIdleTimeout +
                ", threadsCount=" + threadsCount +
                '}';
    }
}
