package ru.yandex.partner.hourglass.configuration.property;

import java.time.Duration;

import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

import ru.yandex.direct.utils.SystemUtils;

@Component
@ConfigurationProperties("juggler")
public class JugglerProps {

    private String project;
    private Duration refreshTime;
    private Meta meta;
    private MetaAggregator metaAggregator;
    private String hostName;
    private String pronounceTemplate;
    private Duration sendEventTimeout;

    public String getPronounceTemplate() {
        return pronounceTemplate;
    }

    public void setPronounceTemplate(String pronounceTemplate) {
        this.pronounceTemplate = pronounceTemplate;
    }

    public String getHostName() {
        return hostName.isEmpty() ? SystemUtils.strictHostname() : hostName;
    }

    public void setHostName(String hostName) {
        this.hostName = hostName;
    }

    public String getProject() {
        return project;
    }

    public void setProject(String project) {
        this.project = project;
    }

    public Duration getRefreshTime() {
        return refreshTime;
    }

    public void setRefreshTime(Duration refreshTime) {
        this.refreshTime = refreshTime;
    }

    public Meta getMeta() {
        return meta;
    }

    public void setMeta(Meta meta) {
        this.meta = meta;
    }

    public MetaAggregator getMetaAggregator() {
        return metaAggregator;
    }

    public void setMetaAggregator(MetaAggregator metaAggregator) {
        this.metaAggregator = metaAggregator;
    }

    public Duration getSendEventTimeout() {
        return sendEventTimeout;
    }

    public void setSendEventTimeout(Duration sendEventTimeout) {
        this.sendEventTimeout = sendEventTimeout;
    }

    public static class Meta {
        private String title;
        private String url;

        public String getTitle() {
            return title;
        }

        public void setTitle(String title) {
            this.title = title;
        }

        public String getUrl() {
            return url;
        }

        public void setUrl(String url) {
            this.url = url;
        }
    }

    public static class MetaAggregator {
        private String serviceName;
        private Duration ttl;
        public String getServiceName() {
            return serviceName;
        }

        public void setServiceName(String serviceName) {
            this.serviceName = serviceName;
        }

        public Duration getTtl() {
            return ttl;
        }

        public void setTtl(Duration ttl) {
            this.ttl = ttl;
        }
    }
}
