package ru.yandex.partner.hourglass.configuration.property;

import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

@Component
@ConfigurationProperties("scheduler")
public class SchedulerProperty {
    private boolean enabled;
    private long taskFetchingIntervalMs;
    private long reschedulingTasksIntervalSec;
    private long maxHeartbeatAgeSec;
    private long pingIntervalMs;
    private long jobsFreeingIntervalSec;
    private long instancePingIntervalMs;
    private long scheduleUpdateIntervalMin;
    private long scheduleHeartbeatExpirationMin;
    private long missedTaskThresholdSec;
    private int threadPoolSize;
    private int leaderVotingLowerBound;

    public boolean isEnabled() {
        return enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public long getTaskFetchingIntervalMs() {
        return taskFetchingIntervalMs;
    }

    public void setTaskFetchingIntervalMs(long taskFetchingIntervalMs) {
        this.taskFetchingIntervalMs = taskFetchingIntervalMs;
    }

    public long getReschedulingTasksIntervalSec() {
        return reschedulingTasksIntervalSec;
    }

    public void setReschedulingTasksIntervalSec(long reschedulingTasksIntervalSec) {
        this.reschedulingTasksIntervalSec = reschedulingTasksIntervalSec;
    }

    public long getMaxHeartbeatAgeSec() {
        return maxHeartbeatAgeSec;
    }

    public void setMaxHeartbeatAgeSec(long maxHeartbeatAgeSec) {
        this.maxHeartbeatAgeSec = maxHeartbeatAgeSec;
    }

    public long getPingIntervalMs() {
        return pingIntervalMs;
    }

    public void setPingIntervalMs(long pingIntervalMs) {
        this.pingIntervalMs = pingIntervalMs;
    }

    public long getJobsFreeingIntervalSec() {
        return jobsFreeingIntervalSec;
    }

    public void setJobsFreeingIntervalSec(long jobsFreeingIntervalSec) {
        this.jobsFreeingIntervalSec = jobsFreeingIntervalSec;
    }

    public long getInstancePingIntervalMs() {
        return instancePingIntervalMs;
    }

    public void setInstancePingIntervalMs(long instancePingIntervalMs) {
        this.instancePingIntervalMs = instancePingIntervalMs;
    }

    public long getScheduleUpdateIntervalMin() {
        return scheduleUpdateIntervalMin;
    }

    public void setScheduleUpdateIntervalMin(long scheduleUpdateIntervalMin) {
        this.scheduleUpdateIntervalMin = scheduleUpdateIntervalMin;
    }

    public long getScheduleHeartbeatExpirationMin() {
        return scheduleHeartbeatExpirationMin;
    }

    public void setScheduleHeartbeatExpirationMin(long scheduleHeartbeatExpirationMin) {
        this.scheduleHeartbeatExpirationMin = scheduleHeartbeatExpirationMin;
    }

    public long getMissedTaskThresholdSec() {
        return missedTaskThresholdSec;
    }

    public void setMissedTaskThresholdSec(long missedTaskThresholdSec) {
        this.missedTaskThresholdSec = missedTaskThresholdSec;
    }

    public int getThreadPoolSize() {
        return threadPoolSize;
    }

    public void setThreadPoolSize(int threadPoolSize) {
        this.threadPoolSize = threadPoolSize;
    }

    public int getLeaderVotingLowerBound() {
        return leaderVotingLowerBound;
    }

    public void setLeaderVotingLowerBound(int leaderVotingLowerBound) {
        this.leaderVotingLowerBound = leaderVotingLowerBound;
    }

    @Override
    public String toString() {
        return "SchedulerProperty{" +
                "enabled=" + enabled +
                ", taskFetchingIntervalMs=" + taskFetchingIntervalMs +
                ", reschedulingTasksIntervalSec=" + reschedulingTasksIntervalSec +
                ", maxHeartbeatAgeSec=" + maxHeartbeatAgeSec +
                ", pingIntervalMs=" + pingIntervalMs +
                ", jobsFreeingIntervalSec=" + jobsFreeingIntervalSec +
                ", instancePingIntervalMs=" + instancePingIntervalMs +
                ", scheduleUpdateIntervalMin=" + scheduleUpdateIntervalMin +
                ", scheduleHeartbeatExpirationMin=" + scheduleHeartbeatExpirationMin +
                ", missedTaskThresholdSec=" + missedTaskThresholdSec +
                ", threadPoolSize=" + threadPoolSize +
                ", leaderVotingLowerBound=" + leaderVotingLowerBound +
                '}';
    }
}
