package ru.yandex.partner.hourglass.jobs;

import java.util.List;
import java.util.Set;

import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.direct.scheduler.Hourglass;
import ru.yandex.partner.core.entity.queue.service.TaskQueueExecutor;
import ru.yandex.partner.core.entity.tasks.convertcpm.ConvertCpmTask;
import ru.yandex.partner.hourglass.monitoring.JugglerCheckFactory;
import ru.yandex.partner.hourglass.monitoring.JugglerCheckTag;
import ru.yandex.partner.hourglass.service.ExecutionHelperService;
import ru.yandex.partner.libs.juggler.JugglerCheck;

@Hourglass(cronExpression = "0 10 * * * *") // each hour at XX:10
public class ConvertCpmWorker extends SimplePartnersJob {
    private final TaskQueueExecutor executor;

    @Autowired
    protected ConvertCpmWorker(
            ExecutionHelperService executionHelperService,
            TaskQueueExecutor executor
    ) {
        super(executionHelperService);
        this.executor = executor;
    }

    @Override
    public JobProcedure getJobCallback() {
        return () -> executor.doOneTask(ConvertCpmTask.class);
    }

    @Override
    public List<JugglerCheck> getJugglerChecks(JugglerCheckFactory jugglerCheckFactory) {
        Long ttl = PartnerJobUtils.getCheckTtlByJobClass(this.getClass());
        String serviceName = getCronName();

        return jugglerCheckFactory.createChecks(serviceName, ttl, Set.of(JugglerCheckTag.STANDARD_NOTIFICATION));
    }
}
