package ru.yandex.partner.hourglass.jobs;

import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.direct.scheduler.Hourglass;
import ru.yandex.partner.hourglass.service.ExecutionHelperService;

//TODO:  needSchedule = TypicalEnvironment.class сделать проверку по env
@Hourglass(cronExpression = "0 */5 * * * *")
public class EmailToProcessingEnqueueingJob extends SimplePartnersJob {

    private final EmailToProcessingJobGenerator jobGenerator;

    @Autowired
    public EmailToProcessingEnqueueingJob(EmailToProcessingJobGenerator jobGenerator,
                                          ExecutionHelperService executionHelperService) {
        super(executionHelperService);
        this.jobGenerator = jobGenerator;
    }

    @Override
    public JobProcedure getJobCallback() {
        // Отдельный jobGenerator сделан, чтобы Transactional метод вызывался из другого класса
        return jobGenerator::generateJobs;
    }
}
