package ru.yandex.partner.hourglass.jobs;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.direct.juggler.JugglerStatus;
import ru.yandex.partner.core.entity.queue.service.TaskQueueExecutor;
import ru.yandex.partner.core.entity.tasks.EmailToProcessingTask;
import ru.yandex.partner.hourglass.service.ExecutionHelperService;
import ru.yandex.partner.hourglass.service.JugglerEventService;

// @Hourglass(cronExpression = "0 */5 * * * *")
public class EmailToProcessingExecutingJob extends SimplePartnersJob {
    private static final Logger logger = LoggerFactory.getLogger(EmailToProcessingExecutingJob.class);

    private final TaskQueueExecutor taskQueueExecutor;
    private final JugglerEventService jugglerEventService;

    @Autowired
    public EmailToProcessingExecutingJob(TaskQueueExecutor taskQueueExecutor,
                                         ExecutionHelperService executionHelperService,
                                         JugglerEventService jugglerEventService) {
        super(executionHelperService);
        this.taskQueueExecutor = taskQueueExecutor;
        this.jugglerEventService = jugglerEventService;
    }

    @Override
    @SuppressWarnings("checkstyle:emptyblock")
    public JobProcedure getJobCallback() {
        return () -> {
            while (taskQueueExecutor.doOneTask(EmailToProcessingTask.class)) {
                jugglerEventService.sendEvent(
                        getCronName(),
                        JugglerStatus.INFO,
                        "HEARTBEAT: just grabbed another EmailToProcessingTask"
                );
            }
        };
    }
}
