package ru.yandex.partner.hourglass.jobs;

import javax.annotation.Nullable;

import ru.yandex.direct.juggler.JugglerStatus;

public interface PartnersJob {

    JobProcedure getJobCallback();

    /**
     * Имя джобы. Используется при создании проверок и при отправке событий в джаглер
     * Должно полностью идентифицировать джобу (если она параметризованная, то имя с параметром)
     */
    String getCronName();

    void setJugglerStatus(@Nullable JugglerStatus status, @Nullable String description);

    JugglerStatus getJugglerStatus();

    String getJugglerDescription();

    default String getJugglerWikiUrl() {
        return "https://wiki.yandex-team.ru/partner/w/devops/monitoring/juggler-checks/cron/";
    }
}
