package ru.yandex.partner.hourglass.jobs;


import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import ru.yandex.direct.scheduler.support.DirectJob;
import ru.yandex.partner.hourglass.monitoring.Alertable;
import ru.yandex.partner.hourglass.monitoring.JugglerCheckFactory;
import ru.yandex.partner.hourglass.service.ExecutionHelperService;
import ru.yandex.partner.libs.juggler.JugglerCheck;


public abstract class SimplePartnersJob extends DirectJob implements PartnersJob, Alertable {
    private static final Logger LOGGER = LoggerFactory.getLogger(SimplePartnersJob.class);

    protected final ExecutionHelperService executionHelperService;

    protected SimplePartnersJob(ExecutionHelperService executionHelperService) {
        this.executionHelperService = executionHelperService;
    }


    /**
     * Интерфейсный метод директовской задачи
     */
    @Override
    public final void execute() {
        executionHelperService.execute(this);
    }

    /**
     * Коллбек с логикой
     */
    public abstract JobProcedure getJobCallback();

    public String getCronName() {
        return this.getClass().getSimpleName();
    }

    @Override
    public List<JugglerCheck> getJugglerChecks(JugglerCheckFactory jugglerCheckFactory) {
        Long ttl = PartnerJobUtils.getCheckTtlByJobClass(this.getClass());
        String serviceName = getCronName();

        return jugglerCheckFactory.createChecks(serviceName, ttl, getJugglerWikiUrl());
    }
}
