package ru.yandex.partner.hourglass.jobs.bk;

import java.util.List;

import org.jetbrains.annotations.Nullable;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Profile;

import ru.yandex.direct.juggler.JugglerStatus;
import ru.yandex.direct.scheduler.Hourglass;
import ru.yandex.partner.hourglass.jobs.JobProcedure;
import ru.yandex.partner.hourglass.jobs.PartnersJob;
import ru.yandex.partner.hourglass.monitoring.Alertable;
import ru.yandex.partner.hourglass.monitoring.JugglerCheckFactory;
import ru.yandex.partner.hourglass.service.DummySolomonServiceImpl;
import ru.yandex.partner.hourglass.service.ExecutionHelperService;
import ru.yandex.partner.hourglass.yql.YqlService;
import ru.yandex.partner.libs.juggler.JugglerCheck;

@Profile("!prod")
@Hourglass
public class StubArriveToBkCheckJob implements PartnersJob, Alertable {
    private static final Logger LOGGER = LoggerFactory.getLogger(StubArriveToBkCheckJob.class);
    private final ArriveToBkCheckJob arriveToBkCheckJob;

    public StubArriveToBkCheckJob() {
        this.arriveToBkCheckJob = new ArriveToBkCheckJob(
                Mockito.mock(ExecutionHelperService.class),
                Mockito.mock(YqlService.class),
                new DummySolomonServiceImpl()
        );
    }

    @Override
    public JobProcedure getJobCallback() {
        return () -> LOGGER.info("I do noting");
    }

    @Override
    public String getCronName() {
        return arriveToBkCheckJob.getCronName();
    }

    @Override
    public void setJugglerStatus(@Nullable JugglerStatus status, @Nullable String description) {
    }

    @Override
    public JugglerStatus getJugglerStatus() {
        return JugglerStatus.INFO;
    }

    @Override
    public String getJugglerDescription() {
        return "I'm stub ArriveToBkJob";
    }

    @Override
    public List<JugglerCheck> getJugglerChecks(JugglerCheckFactory jugglerCheckFactory) {
        return arriveToBkCheckJob.getJugglerChecks(jugglerCheckFactory);
    }
}
