package ru.yandex.partner.hourglass.jobs.doaction;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;

import ru.yandex.direct.scheduler.Hourglass;
import ru.yandex.direct.scheduler.support.ParameterizedBy;
import ru.yandex.partner.core.entity.queue.service.TaskQueueExecutor;
import ru.yandex.partner.core.entity.tasks.doaction.DoActionTask;
import ru.yandex.partner.hourglass.jobs.JobProcedure;
import ru.yandex.partner.hourglass.jobs.PartnersParamsJob;
import ru.yandex.partner.hourglass.service.ExecutionHelperService;

@Hourglass(cronExpression = "*/5 * * * * *")
@ParameterizedBy(parametersSource = DoActionJobParams.class)
public class DoActionJob extends PartnersParamsJob<Integer> {
    private final TaskQueueExecutor executor;

    @Value("${app.multipleJobsLimit}")
    private Integer multipleJobsLimit;

    @Autowired
    protected DoActionJob(ExecutionHelperService executionHelperService,
                          TaskQueueExecutor executor,
                          ApplicationContext applicationContext) {
        super(executionHelperService, applicationContext);
        this.executor = executor;
    }

    @Override
    public JobProcedure getJobCallback() {
        return () -> executor.doMultipleTask(DoActionTask.class, this.multipleJobsLimit);
    }
}
