package ru.yandex.partner.hourglass.jobs.validation;


import org.springframework.context.ApplicationContext;

import ru.yandex.direct.juggler.JugglerStatus;
import ru.yandex.partner.core.service.statevalidation.StateValidationService;
import ru.yandex.partner.core.service.statevalidation.block.BlockStateValidationService;
import ru.yandex.partner.hourglass.jobs.JobProcedure;
import ru.yandex.partner.hourglass.jobs.PartnersParamsJob;
import ru.yandex.partner.hourglass.service.ExecutionHelperService;

public abstract class AbstractValidationJob extends PartnersParamsJob<Integer> {
    private final StateValidationService stateValidationService;
    private volatile boolean isShutdown = false;

    protected AbstractValidationJob(BlockStateValidationService stateValidationService,
                                    ExecutionHelperService executionHelperService,
                                    ApplicationContext applicationContext) {
        super(executionHelperService, applicationContext);
        this.stateValidationService = stateValidationService;
    }

    @Override
    public JobProcedure getJobCallback() {
        return () -> {
            var reminder = getParam();

            var validationResult =
                    stateValidationService.validateObjects(Integer.parseInt(reminder), () -> !isShutdown);

            if (validationResult.wasInterrupted() && validationResult.getProblemElements() == 0) {
                this.setJugglerStatus(JugglerStatus.WARN, validationResult.toString());
            } else if (validationResult.getProblemElements() > 0) {
                this.setJugglerStatus(JugglerStatus.CRIT, validationResult.toString());
            }
        };
    }

    @Override
    public void onShutdown() {
        super.onShutdown();
        isShutdown = true;
    }

    @Override
    public String getJugglerWikiUrl() {
        return "https://wiki.yandex-team.ru/partner/w/devops/monitoring/juggler-checks/proverkavalidaciivjava/";
    }
}
