package ru.yandex.partner.hourglass.jobs.validation.block;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Profile;

import ru.yandex.direct.scheduler.Hourglass;
import ru.yandex.direct.scheduler.support.ParameterizedBy;
import ru.yandex.partner.core.service.statevalidation.block.InternalMobileRtbStateValidationService;
import ru.yandex.partner.hourglass.jobs.validation.AbstractValidationJob;
import ru.yandex.partner.hourglass.service.ExecutionHelperService;

@Profile("prod | dev | test | default")
@ParametersAreNonnullByDefault
@Hourglass(cronExpression = "0 0 */6 * * ?")
@ParameterizedBy(parametersSource = InternalMobileRtbBlockValidationJobParams.class)
public class InternalMobileRtbBlockValidationJob extends AbstractValidationJob {


    protected InternalMobileRtbBlockValidationJob(InternalMobileRtbStateValidationService stateValidationService,
                                                  ExecutionHelperService executionHelperService,
                                                  ApplicationContext applicationContext) {
        super(stateValidationService, executionHelperService, applicationContext);
    }
}
