package ru.yandex.partner.hourglass.monitoring;

import org.jooq.DSLContext;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.annotation.EnableScheduling;

import ru.yandex.partner.hourglass.service.JugglerEventService;

@Configuration
@ConditionalOnProperty(
        // мониторим шедулер, только если он включен
        value = "scheduler.enabled",
        havingValue = "true",
        matchIfMissing = true)
@EnableScheduling
public class SchedulerInstancesMonitoringConfiguration {

    @Bean
    public SchedulerInstancesMonitoring scheduledInstancesMonitoring(
            DSLContext dslContext,
            JugglerEventService jugglerEventService,
            SchedulerInstancesProps schedulerInstancesProps
    ) {
        return new SchedulerInstancesMonitoring(
                dslContext,
                jugglerEventService,
                schedulerInstancesProps
        );
    }
}
