package ru.yandex.partner.hourglass.parameters;

import java.util.ArrayList;
import java.util.List;

import ru.yandex.direct.scheduler.support.ParametersSource;

public abstract class AbstractThreadsCount implements ParametersSource<Integer> {

    private final int threadsCount;

    public AbstractThreadsCount(int threadsCount) {
        this.threadsCount = threadsCount;
    }

    @Override
    public List<Integer> getAllParamValues() {
        var params = new ArrayList<Integer>(threadsCount);
        for (int i = 0; i < threadsCount; i++) {
            params.add(i);
        }
        return params;
    }

    @Override
    public String convertParamToString(Integer paramValue) {
        return String.valueOf(paramValue);
    }

    @Override
    public Integer convertStringToParam(String string) {
        return Integer.valueOf(string);
    }
}
