package ru.yandex.partner.hourglass.service;

import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Map;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

import ru.yandex.direct.juggler.JugglerStatus;
import ru.yandex.partner.defaultconfiguration.PartnerLocalDateTime;
import ru.yandex.partner.hourglass.jobs.PartnerJobUtils;
import ru.yandex.partner.hourglass.jobs.PartnersJob;

@Service
public class ExecutionHelperService {

    private static final Logger LOGGER = LoggerFactory.getLogger(ExecutionHelperService.class);

    private final SolomonService solomonService;
    private final JugglerEventService jugglerEventService;

    public ExecutionHelperService(
            SolomonService solomonService,
            JugglerEventService jugglerEventService
    ) {
        this.solomonService = solomonService;
        this.jugglerEventService = jugglerEventService;
    }

    public void execute(PartnersJob job) {
        PartnerJobUtils.putToMDC(job.getCronName());

        LocalDateTime startTime = PartnerLocalDateTime.now();
        try {
            job.getJobCallback().run();
        } catch (Exception e) {
            job.setJugglerStatus(JugglerStatus.CRIT, e.getMessage());
            LOGGER.error(e.getMessage(), e);
        }
        LocalDateTime endTime = PartnerLocalDateTime.now();

        long timePassed = ChronoUnit.SECONDS.between(startTime, endTime);
        LOGGER.info("[Cron %s] END (%d sec)".formatted(job.getCronName(), timePassed));
        solomonService.sendToSolomon(
                Map.of(
                        "type", "cron",
                        "sensor", "timing",
                        "cron_path", job.getCronName()
                ),
                timePassed
        );
        jugglerEventService.sendEvent(
                job.getCronName(),
                job.getJugglerStatus(),
                job.getJugglerDescription()
        );
    }
}
