package ru.yandex.partner.hourglass.service;

import java.util.List;

import javax.annotation.PostConstruct;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import ru.yandex.partner.hourglass.monitoring.Alertable;
import ru.yandex.partner.hourglass.monitoring.JugglerCheckFactory;
import ru.yandex.partner.libs.juggler.JugglerCheck;
import ru.yandex.partner.libs.juggler.JugglerCheckApiClient;

/**
 * Создает проверки на старте приложения
 */
@Service
public class JugglerCheckService {
    private static final Logger LOGGER = LoggerFactory.getLogger(JugglerCheckService.class);

    private final List<Alertable> alertables;
    private final JugglerCheckApiClient apiClient;
    private final JugglerCheckFactory jugglerCheckFactory;

    @Autowired
    public JugglerCheckService(
            List<Alertable> alertables,
            JugglerCheckApiClient apiClient,
            JugglerCheckFactory jugglerCheckFactory
    ) {
        this.alertables = alertables;
        this.apiClient = apiClient;
        this.jugglerCheckFactory = jugglerCheckFactory;
    }

    @PostConstruct
    private void createChecks() {
        alertables.stream()
                .flatMap(a -> a.getJugglerChecks(jugglerCheckFactory).stream())
                .forEach(this::sendCheck);

        JugglerCheck metaCheck = jugglerCheckFactory.createMetaCheck();
        sendCheck(metaCheck);
    }

    private void sendCheck(JugglerCheck check) {
        try {
            boolean success = apiClient.addOrUpdateCheck(check);
            if (!success) {
                throw new RuntimeException("Juggler checks API returned success=false");
            } else {
                LOGGER.info("Request to creating {} ended with success!", check.getService());
            }
        } catch (RuntimeException e) {
            LOGGER.error("Failed to create juggler check for {}", check.getService(), e);
        }
    }
}
