package ru.yandex.partner.hourglass.service;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import ru.yandex.direct.juggler.JugglerEvent;
import ru.yandex.direct.juggler.JugglerSender;
import ru.yandex.direct.juggler.JugglerStatus;
import ru.yandex.partner.hourglass.configuration.property.JugglerProps;

/**
 * отправляет в сырые ивенты в juggler
 */
@Service
public class JugglerEventService {
    private static final Logger LOGGER = LoggerFactory.getLogger(JugglerEventService.class);
    private final JugglerSender jugglerSender;
    private final JugglerProps properties;

    @Autowired
    public JugglerEventService(JugglerSender jugglerSender, JugglerProps properties) {
        this.jugglerSender = jugglerSender;
        this.properties = properties;
    }

    public void sendEvent(String service, JugglerStatus status, String description) {
        JugglerEvent jugglerEvent = new JugglerEvent(
                properties.getHostName(),
                service,
                status,
                description
        );
        try {
            jugglerSender.sendEvent(jugglerEvent, properties.getSendEventTimeout());
        } catch (Exception e) {
            LOGGER.error("Failed to send event to juggler", e);
        }
    }
}
