package ru.yandex.partner.hourglass.service;

import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.web.reactive.function.BodyInserters;
import org.springframework.web.reactive.function.client.WebClient;

import ru.yandex.partner.hourglass.configuration.property.SolomonRpcConfig;

import static ru.yandex.partner.libs.common.PartnerRequestService.retryWithBackoff;
import static ru.yandex.partner.libs.common.PartnerRequestService.serviceUnavailable;

@Service
public class SolomonRequestExecutor {

    private final WebClient webClient;
    private final SolomonRpcConfig solomonRpcConfig;

    public SolomonRequestExecutor(SolomonRpcConfig solomonRpcConfig, WebClient webClient) {
        this.webClient = webClient;
        this.solomonRpcConfig = solomonRpcConfig;
    }

    public ResponseEntity<String> pushToSolomon(String jsonData) {
        return webClient.post()
                .uri(solomonRpcConfig.getUrl())
                .header("Content-Type", "application/json")
                .header("Accept", "application/json")
                .body(BodyInserters.fromValue(jsonData))
                .exchangeToMono(clientResponse -> clientResponse.toEntity(String.class))
                .transform(retryWithBackoff(solomonRpcConfig))
                .blockOptional()
                .orElse(serviceUnavailable());
    }
}
