package ru.yandex.partner.hourglass.yql;

import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Service;

import ru.yandex.partner.core.configuration.YTProperties;

@Service
public class YqlService {

    private static final Logger LOGGER = LoggerFactory.getLogger(YqlService.class);
    private final JdbcTemplate yqlJdbcTemplate;
    private final YTProperties ytProperties;

    public YqlService(@Qualifier("yqlJdbcTemplate") JdbcTemplate yqlJdbcTemplate,
                      YTProperties ytProperties) {
        this.yqlJdbcTemplate = yqlJdbcTemplate;
        this.ytProperties = ytProperties;
    }

    public <T> List<T> query(String baseQuery, RowMapper<T> rowMapper) {
        for (String cluster : ytProperties.getReplicas()) {
            String queryWithCluster = "use %s;\n".formatted(cluster).concat(baseQuery);
            try {
                return yqlJdbcTemplate.query(queryWithCluster, rowMapper);
            } catch (RuntimeException e) {
                LOGGER.warn("Query %s to cluster %s is failed".formatted(queryWithCluster, cluster), e);
            }
        }
        throw new RuntimeException("Query %s has failed on all clusters".formatted(baseQuery));
    }
}
