package ru.yandex.partner.hourglass.configuration;

import java.util.List;

import javax.sql.DataSource;

import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.test.context.TestConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.jdbc.core.JdbcTemplate;

import ru.yandex.partner.hourglass.yql.YqlService;

import static org.mockito.ArgumentMatchers.any;
import static org.mockito.ArgumentMatchers.anyString;
import static org.mockito.Mockito.mock;
import static org.mockito.Mockito.when;

@TestConfiguration
public class YqlServiceTestConfiguration {

    @Bean
    YqlService yqlService() {
        YqlService service = mock(YqlService.class);
        when(service.query(anyString(), any())).thenReturn(List.of());
        return service;
    }

    @Bean(name = "yqlDataSource")
    public DataSource yqlDataSource() {
        return mock(DataSource.class);
    }

    @Bean(name = "yqlJdbcTemplate")
    public JdbcTemplate yqlJdbcTemplate(@Qualifier("yqlDataSource") DataSource dataSource) {
        return mock(JdbcTemplate.class);
    }
}
