package ru.yandex.partner.hourglass.jobs;

import java.time.Duration;

import org.junit.jupiter.api.Test;

import static org.junit.jupiter.api.Assertions.assertEquals;

class PartnerJobUtilsTest {


    @Test
    void calculateCheckTtlCantBeLessThan1Hour() {
        Long ttl = PartnerJobUtils.calculateCheckTtl(Duration.ofMinutes(30).toSeconds());

        assertEquals(Duration.ofHours(1).toSeconds(), ttl);
    }

    @Test
    void calculateCheckTtlCantBeGreaterThan10Days() {
        Long ttl = PartnerJobUtils.calculateCheckTtl(Duration.ofDays(11).toSeconds());

        assertEquals(Duration.ofDays(10).toSeconds(), ttl);
    }
}
