package ru.yandex.partner.hourglass.service;

import javax.annotation.ParametersAreNonnullByDefault;

import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.mock.mockito.MockBean;

import ru.yandex.direct.juggler.JugglerStatus;
import ru.yandex.direct.scheduler.hourglass.TaskParametersMap;
import ru.yandex.direct.scheduler.support.PeriodicJobWrapper;
import ru.yandex.partner.defaultconfiguration.TimeZoneConfiguration;
import ru.yandex.partner.hourglass.jobs.JobProcedure;
import ru.yandex.partner.hourglass.jobs.SimplePartnersJob;

import static org.mockito.ArgumentMatchers.anyString;
import static org.mockito.ArgumentMatchers.eq;
import static org.mockito.Mockito.atLeastOnce;
import static org.mockito.Mockito.mock;
import static org.mockito.Mockito.verify;

@SpringBootTest(
        properties = "spring.main.allow-bean-definition-overriding=true",
        classes = TimeZoneConfiguration.class
)
@Execution(ExecutionMode.SAME_THREAD)
@ParametersAreNonnullByDefault
class JobJugglerMonitoringInterceptorTest {
    private static final Logger logger = LoggerFactory.getLogger(JobJugglerMonitoringInterceptorTest.class);

    @MockBean
    SolomonService solomonServiceImpl;

    @Test
    void testOKJugglerJob() {
        JugglerEventService mockService = mock(JugglerEventService.class);

        var okJob = new SimplePartnersJob(new ExecutionHelperService(solomonServiceImpl, mockService)) {
            @Override
            public JobProcedure getJobCallback() {
                return () -> logger.info("Ok job started");
            }
        };
        new PeriodicJobWrapper(okJob).execute(TaskParametersMap.of());

        verify(mockService, atLeastOnce()).sendEvent(anyString(), eq(JugglerStatus.OK), anyString());
    }

    @Test
    void testCritJugglerJob() {
        JugglerEventService mockService = mock(JugglerEventService.class);

        var critJob = new SimplePartnersJob(new ExecutionHelperService(solomonServiceImpl, mockService)) {
            @Override
            public JobProcedure getJobCallback() {
                return () -> {
                    logger.info("Crit job started");
                    throw new RuntimeException("Something goes wrong");
                };
            }
        };
        new PeriodicJobWrapper(critJob).execute(TaskParametersMap.of());

        verify(mockService, atLeastOnce()).sendEvent(anyString(), eq(JugglerStatus.CRIT), anyString());
    }
}
