package ru.yandex.partner.hourglass.service;

import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.mockito.ArgumentCaptor;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.mock.mockito.MockBean;

import ru.yandex.partner.core.configuration.BalanceTestConfiguration;
import ru.yandex.partner.hourglass.configuration.AuthTestConfiguration;
import ru.yandex.partner.hourglass.configuration.YqlServiceTestConfiguration;
import ru.yandex.partner.hourglass.monitoring.SchedulerInstancesMonitoringTestConfiguration;
import ru.yandex.partner.libs.juggler.JugglerCheck;
import ru.yandex.partner.libs.juggler.JugglerCheckApiClient;
import ru.yandex.partner.test.db.MysqlTestConfiguration;
import ru.yandex.partner.test.utils.TestUtils;

import static org.mockito.Mockito.atLeastOnce;
import static org.mockito.Mockito.verify;

@SpringBootTest(
        properties = {
                "spring.main.allow-bean-definition-overriding=true",
                "juggler.hostName=test-host-name",
                "scheduler.enabled=false"
        },
        classes = {MysqlTestConfiguration.class, AuthTestConfiguration.class, BalanceTestConfiguration.class,
                YqlServiceTestConfiguration.class, SchedulerInstancesMonitoringTestConfiguration.class}
)
@Execution(ExecutionMode.SAME_THREAD)
public class JugglerCheckServiceTest {
    @MockBean
    JugglerCheckApiClient jugglerCheckApiClient;

    @Test
    void test() throws Exception {
        ArgumentCaptor<JugglerCheck> captor = ArgumentCaptor.forClass(JugglerCheck.class);

        verify(jugglerCheckApiClient, atLeastOnce()).addOrUpdateCheck(captor.capture());

        for (JugglerCheck createdCheck : captor.getAllValues()) {
            String fileName = createdCheck.getService() + ".json";
            TestUtils.compareToDataFromFile(createdCheck, this.getClass(), fileName);
        }
    }
}
