package ru.yandex.partner.hourglass.service;

import java.util.List;
import java.util.Map;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

import ru.yandex.partner.hourglass.jackson.Metric;
import ru.yandex.partner.hourglass.jackson.SolomonRequest;
import ru.yandex.partner.test.utils.TestUtils;

class SolomonServiceTest {

    ObjectMapper objectMapper = new ObjectMapper();

    @Test
    void checkMetricsSent() {
        var request = new SolomonRequest(List.of(new Metric(Map.of("name", "test", "sensor", "test"), 15)));
        try {
            var jsonObj = objectMapper
                    .configure(SerializationFeature.ORDER_MAP_ENTRIES_BY_KEYS, true)
                    .writeValueAsString(request);
            TestUtils.compareToDataFromFile(jsonObj, this.getClass(), "solomon_request.json");
        } catch (Exception e) {
            Assertions.fail(e.getMessage());
        }
    }
}
