#!/bin/bash -e

APP_ROOT=${1:-/app/java/intapi}

/usr/bin/java \
    -cp "$APP_ROOT/lib/*:" \
    -Dspring.profiles.active=$INTAPI_PROFILE \
    -Dserver.port=${INTAPI_SERVER_PORT} \
    -Dmanagement.server.port=${INTAPI_MANAGEMENT_PORT:-9791} \
    -Dspring.pid.file=${INTAPI_PID_FILE:-/var/run/intapi.pid} \
    -Dlogging.filepath=${INTAPI_LOG_FILE:-./java-dev.log} \
    ${JAVA_OPTS} \
    -Xmx2g \
    ru.yandex.partner.intapi.App
