package ru.yandex.partner.intapi.acl;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * Аннотация показывает, что перед вызовом аннотированного ей метода должна пройти проверка прав ACL.
 * Применяется к методу.
 * <p>
 * Пример использования:
 *
 * @ACL(path="abc" method="xyz")
 * ... methodName(...)
 * <p>
 * Перед вызовом methodName ACL произведёт поиск в таблице INTAPI_ACL и проверит, имеет ли IP пользователя
 * доступ к методу abc/xyz
 */
@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.METHOD)
public @interface ACL {
    /**
     * Путь в таблице INTAPI_ACL
     *
     * @return Имя пути
     */
    String path() default "";

    /**
     * Имя метода в таблице INTAPI_ACL
     *
     * @return Имя метода
     */
    String method() default "";
}
