package ru.yandex.partner.intapi.acl;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

import ru.yandex.partner.intapi.Utils;

/**
 * Interceptor класс для проверки прав доступа ACL
 */
@Component
public class ACLInterceptor extends HandlerInterceptorAdapter {
    private static final Logger LOGGER = LoggerFactory.getLogger(ACLInterceptor.class);
    private ACLService aclService;

    @Autowired
    public void setAclService(ACLService aclService) {
        this.aclService = aclService;
    }

    @Override
    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler)
            throws Exception {
        if (!(handler instanceof HandlerMethod)) {
            return super.preHandle(request, response, handler);
        }

        ACL aclParams = ((HandlerMethod) handler).getMethod().getAnnotation(ACL.class);

        if (aclParams != null) {
            boolean auth = aclService.checkACL(
                    new ACLRequestPath(aclParams.path(), aclParams.method()),
                    Utils.getIpAddrFromRequest(request)
            );

            if (!auth) {
                String error = String.format("Authorization error for %s/%s from %s", aclParams.path(),
                        aclParams.method(), Utils.getIpAddrFromRequest(request));
                LOGGER.error(error);
                response.sendError(HttpServletResponse.SC_FORBIDDEN);
            }
            return auth;
        } else {
            return super.preHandle(request, response, handler);
        }
    }
}
