package ru.yandex.partner.intapi.acl;

import java.util.Collections;
import java.util.List;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.github.jgonian.ipmath.AbstractIpRange;
import org.jooq.DSLContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheConfig;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Repository;

import ru.yandex.partner.defaultconfiguration.CacheNames;
import ru.yandex.partner.intapi.Utils;

import static ru.yandex.partner.dbschema.partner.tables.IntapiAcl.INTAPI_ACL;

/**
 * Класс доступа к данным ACL из таблица INTAPI_ACL
 */
@CacheConfig(cacheNames = CacheNames.ACL_PATH_IP_RANGE_CACHE)
@Repository
public class ACLRepository implements IACLRepository {
    private final DSLContext dslContext;

    @Autowired
    public ACLRepository(DSLContext dsl) {
        this.dslContext = dsl;
    }

    @Cacheable
    @Nonnull
    @Override
    public List<AbstractIpRange> getACL(@Nonnull ACLRequestPath aclRequestPath) {
        if (aclRequestPath.getPath() == null || aclRequestPath.getMethod() == null) {
            return Collections.emptyList();
        }

        return Utils.jsonStringToRanges(getDBResponse(aclRequestPath.getPath(), aclRequestPath.getMethod()));
    }

    private @Nullable
    String getDBResponse(@Nonnull String path, @Nonnull String method) {
        return this.dslContext.select(INTAPI_ACL.ACL_CACHED)
                .from(INTAPI_ACL)
                .where(INTAPI_ACL.PATH.eq(path))
                .and(INTAPI_ACL.METHOD.eq(method))
                .fetchOne(INTAPI_ACL.ACL_CACHED);
    }

    @CacheEvict(allEntries = true)
    @Override
    public void clearACLCache() {

    }
}
