package ru.yandex.partner.intapi.acl;

import java.util.Objects;

/**
 * Класс пути к методу ACL в таблице INTAPI_ACL
 * Полный путь к методу состоит из: имя_пути/имя_метода
 */
public class ACLRequestPath {
    private String path;
    private String method;

    public ACLRequestPath(String path, String method) {
        this.path = path;
        this.method = method;
    }

    public String getPath() {
        return path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getMethod() {
        return method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ACLRequestPath that = (ACLRequestPath) o;
        return Objects.equals(path, that.path) &&
                Objects.equals(method, that.method);
    }

    @Override
    public int hashCode() {
        return Objects.hash(path, method);
    }
}
