package ru.yandex.partner.intapi.acl;

import java.util.List;

import javax.annotation.Nonnull;

import com.github.jgonian.ipmath.AbstractIpRange;

public interface IACLRepository {
    /**
     * Получает данные по ACL доступу для конкретного пути/метода.
     *
     * @param aclRequestPath Путь для проверки доступа
     * @return Список подсетей типа Ipv4Range/Ipv6Range
     */
    @Nonnull
    List<AbstractIpRange> getACL(@Nonnull ACLRequestPath aclRequestPath);

    void clearACLCache();
}
