package ru.yandex.partner.intapi.antifrod;

import java.util.List;

import org.jooq.DSLContext;
import org.jooq.impl.DSL;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import static org.jooq.impl.DSL.groupConcat;
import static ru.yandex.partner.dbschema.partner.Tables.ALL_PAGES;
import static ru.yandex.partner.dbschema.partner.Tables.ASSISTANTS;

/**
 * Класс предоставляет доступ к данным для метода page_owner_report API ПИ2
 */
@Service
public class DbQueryService {
    private final DSLContext dsl;

    @Autowired
    public DbQueryService(DSLContext dsl) {
        this.dsl = dsl;
    }

    public DSLContext getDsl() {
        return dsl;
    }

    /**
     * Метод получает данные из базы
     *
     * @param rowLimit количество строк для выборки из базы (аналог LIMIT в SQL)
     * @return список объектов
     */
    public List<PageOwnerData> fetchAll(Integer rowLimit) {
        return dsl.select(
                ALL_PAGES.PAGE_ID,
                ALL_PAGES.LOGIN,
                ALL_PAGES.OWNER_ID,
                groupConcat(ASSISTANTS.USER_ID))
                .from(ALL_PAGES
                        .leftJoin(ASSISTANTS)
                        .using(ALL_PAGES.PAGE_ID))
                .where(ALL_PAGES.IS_BALANCE_REGISTERED.eq(1L).and(ALL_PAGES.MODEL.ne("distribution_campaign")))
                .groupBy(ALL_PAGES.PAGE_ID, ALL_PAGES.LOGIN, ALL_PAGES.OWNER_ID)
                .orderBy(ALL_PAGES.PAGE_ID)
                .limit(rowLimit != null ? DSL.param("limit", rowLimit) : null)
                .fetch(r -> new PageOwnerData(r.value1(), r.value2(), r.value3(), r.value4()));
    }
}
