package ru.yandex.partner.intapi.antifrod;

import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Класс обёртки данных для метода page_owner_report API ПИ2
 * <p>
 * Поля класса
 * pageId         идентификатор площадки
 * login          логин владельца площадки
 * ownerId        идентификатор владельца площадки
 * assistants     идентификаторы ассистентов, перечисленные через запятую
 */
public class PageOwnerData {
    private Long pageId;
    private String login;
    private Long ownerId;
    private String assistants;

    @JsonCreator
    public PageOwnerData(@JsonProperty("page_id") Long pageId,
                         @JsonProperty("login") String login,
                         @JsonProperty("owner_id") Long ownerId,
                         @JsonProperty("assistants") String assistants) {
        this.pageId = pageId;
        this.login = login;
        this.ownerId = ownerId;
        this.assistants = assistants;
    }

    public Long getPageId() {
        return pageId;
    }

    public void setPageId(Long pageId) {
        this.pageId = pageId;
    }

    public String getLogin() {
        return login;
    }

    public void setLogin(String login) {
        this.login = login;
    }

    public Long getOwnerId() {
        return ownerId;
    }

    public void setOwnerId(Long ownerId) {
        this.ownerId = ownerId;
    }

    public String getAssistants() {
        return assistants;
    }

    public void setAssistants(String assistants) {
        this.assistants = assistants;
    }

    @Override
    public String toString() {
        return "PageOwnerData{" +
                "pageId=" + pageId +
                ", login='" + login + '\'' + " #isnull=" + (login == null) +
                ", ownerId=" + ownerId +
                ", assistants='" + assistants + '\'' + " #isnull=" + (assistants == null) +
                '}';
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        PageOwnerData that = (PageOwnerData) o;
        return Objects.equals(pageId, that.pageId) &&
                Objects.equals(login, that.login) &&
                Objects.equals(ownerId, that.ownerId) &&
                Objects.equals(assistants, that.assistants);
    }

    @Override
    public int hashCode() {
        return Objects.hash(pageId, login, ownerId, assistants);
    }
}
