package ru.yandex.partner.intapi.antifrod;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import ru.yandex.partner.intapi.acl.ACL;
import ru.yandex.partner.intapi.queryresult.QueryOptions;
import ru.yandex.partner.intapi.queryresult.QueryResult;

import static ru.yandex.partner.intapi.configuration.WebConfig.CONTENT_TYPE_TSV;

/**
 * Класс контроллера для получения отчёта от метода page_owner_report API ПИ2
 * базовый URL для маппинга /intapi/antifrod
 */
@RestController
@RequestMapping(path = {"/intapi/antifrod"})
public class PageOwnerReportController {
    private DbQueryService dataQueryService;

    @Autowired
    public PageOwnerReportController(DbQueryService dataQueryService) {
        this.dataQueryService = dataQueryService;
    }

    /**
     * Метод формирует и возвращает отчёт от метода page_owner_report API ПИ2
     * Базовый URL для маппинга /page_owner_report
     * <p>
     * Возвращает список всех пейджей, логинов, id их владельцев и ассистентов.
     * <p>
     * Wiki
     * https://wiki.yandex-team.ru/partner/w/partner2-intapi-antifrod-page-owner-report
     *
     * @param rowLimit количество строк для выборки из базы (аналог LIMIT в SQL)
     * @return объект отчёта
     */
    @RequestMapping(
            path = {"/page_owner_report"},
            produces = {"application/json", "application/xml", CONTENT_TYPE_TSV}
    )
    @ACL(path = "antifrod", method = "page_owner_report")
    public QueryResult<PageOwnerData> getPageOwnerReportReport(
            @RequestParam(name = "limit", required = false) Integer rowLimit
    ) {
        QueryOptions options = new QueryOptions(true);
        List<String> fields = List.of("page_id", "login", "owner_id", "assistants");
        List<PageOwnerData> data = dataQueryService.fetchAll(rowLimit);

        return new QueryResult<>(options, fields, data);
    }
}
