package ru.yandex.partner.intapi.configuration;

import com.github.benmanes.caffeine.cache.Caffeine;
import org.springframework.cache.Cache;
import org.springframework.cache.annotation.EnableCaching;
import org.springframework.cache.caffeine.CaffeineCache;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.partner.defaultconfiguration.CacheNames;
import ru.yandex.partner.intapi.acl.ACLConfig;

@EnableCaching
@Configuration
public class CacheConfiguration {

    @Bean
    Cache aclPathIpRangeCache(ACLConfig aclConfig) {
        return new CaffeineCache(
                CacheNames.ACL_PATH_IP_RANGE_CACHE,
                Caffeine.newBuilder()
                        .maximumSize(aclConfig.getCacheSize())
                        .expireAfterAccess(aclConfig.getCacheTtl())
                        .build()
        );
    }
}
