package ru.yandex.partner.intapi.logging;

import java.io.IOException;

import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.stereotype.Component;

@Component
public class IntAPILoggingFilter implements Filter {

    private static final Logger LOGGER = LoggerFactory.getLogger(IntAPILoggingFilter.class);

    @Override
    public void init(FilterConfig filterConfig) throws ServletException {
        // do nothing
    }

    @Override
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException,
            ServletException {
        try {
            if (request instanceof HttpServletRequest) {
                HttpServletRequest httpRequest = (HttpServletRequest) request;
                MDC.put("http_method", httpRequest.getMethod());
                MDC.put("http_url", httpRequest.getRequestURL().toString());
                MDC.put("http_query_string", httpRequest.getQueryString());
            }
            LOGGER.info("Start processing request");
            chain.doFilter(request, response);
        } finally {
            MDC.put("http_response_code", Integer.toString(((HttpServletResponse) response).getStatus()));
            LOGGER.info("Finish processing request");
            MDC.remove("http_method");
            MDC.remove("http_url");
            MDC.remove("http_query_string");
            MDC.remove("http_response_code");
        }
    }

    @Override
    public void destroy() {
        // do nothing
    }
}
