package ru.yandex.partner.intapi.queryresult;

import java.util.List;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Параметризованный класс обёртка ответа API получения данных из базы
 *
 * @param <T> - тип параметра возвращаемых данных
 *            <p>
 *            Поля класса
 *            options  объект с параметрами запроса
 *            fields   названия полей данных
 *            data     список объектов данных
 */
public class QueryResult<T> {
    private QueryOptions options;
    private List<String> fields;
    private List<T> data;

    @JsonCreator
    public QueryResult(@JsonProperty("options") QueryOptions options,
                       @JsonProperty("fields") List<String> fields,
                       @JsonProperty("data") List<T> data) {
        this.options = options;
        this.fields = fields;
        this.data = data;
    }

    public QueryOptions getOptions() {
        return options;
    }

    public void setOptions(QueryOptions options) {
        this.options = options;
    }

    public List<String> getFields() {
        return fields;
    }

    public void setFields(List<String> fields) {
        this.fields = fields;
    }

    public List<T> getData() {
        return data;
    }

    public void setData(List<T> data) {
        this.data = data;
    }

    @Override
    public String toString() {
        return "QueryResult{" +
                "options=" + options +
                ", fields=" + fields +
                ", data=" + data +
                '}';
    }
}
