package ru.yandex.partner.intapi;

import java.io.IOException;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.commons.io.FileUtils;
import org.springframework.core.io.ClassPathResource;

import ru.yandex.partner.intapi.antifrod.DbQueryService;

import static ru.yandex.partner.dbschema.partner.Tables.INTAPI_ACL;

public class IntApiTestUtils {
    private static ObjectMapper objectMapper = new ObjectMapper();

    private IntApiTestUtils() {
    }

    public static ObjectMapper getMapper() {
        return objectMapper;
    }

    public static <T> T readJsonFromResource(String resourcePath, TypeReference<T> type) throws IOException {
        return objectMapper.readValue(
                FileUtils.readFileToString(new ClassPathResource(resourcePath).getFile()),
                type
        );
    }

    public static void addLocalAclDbRecord(DbQueryService dbQueryService) {
        dbQueryService.getDsl().insertInto(INTAPI_ACL,
                INTAPI_ACL.PATH, INTAPI_ACL.METHOD, INTAPI_ACL.ACL, INTAPI_ACL.ACL_CACHED)
                .values("antifrod", "page_owner_report", "all", "[\"127.0.0.1/32\",\"0:0:0:0:0:0:0:1/128\"]")
                .execute();
    }

    public static void removeLocalAclDbRecord(DbQueryService dbQueryService) {
        dbQueryService.getDsl().delete(INTAPI_ACL)
                .where(INTAPI_ACL.PATH.eq("antifrod").and(INTAPI_ACL.METHOD.eq("page_owner_report")))
                .execute();
    }
}
