package ru.yandex.partner.intapi.acl;

import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.junit.jupiter.SpringExtension;
import org.springframework.test.web.servlet.MockMvc;

import ru.yandex.partner.intapi.IntApiTestUtils;
import ru.yandex.partner.intapi.antifrod.DbQueryService;
import ru.yandex.partner.intapi.configuration.IntapiTest;

import static org.springframework.test.web.servlet.request.MockMvcRequestBuilders.get;
import static org.springframework.test.web.servlet.result.MockMvcResultMatchers.status;

@IntapiTest
@ExtendWith(SpringExtension.class)
public class AclTest {
    @Autowired
    DbQueryService dbQueryService;

    @Autowired
    MockMvc mvc;

    @Autowired
    ACLConfig aclConfig;

    @Autowired
    ACLRepository aclRepository;

    @Test
    void checkAclDbRecord() throws Exception {
        aclConfig.setAllowLocalhost(false);

        aclRepository.clearACLCache();
        IntApiTestUtils.addLocalAclDbRecord(dbQueryService);
        mvc.perform(get("/intapi/antifrod/page_owner_report")).andExpect(status().isOk());

        aclRepository.clearACLCache();
        IntApiTestUtils.removeLocalAclDbRecord(dbQueryService);
        mvc.perform(get("/intapi/antifrod/page_owner_report")).andExpect(status().isForbidden());
    }

    @Test
    void checkLocalEnableAclAccess() throws Exception {
        aclRepository.clearACLCache();

        aclConfig.setAllowLocalhost(true);
        mvc.perform(get("/intapi/antifrod/page_owner_report")).andExpect(status().isOk());

        aclConfig.setAllowLocalhost(false);
        mvc.perform(get("/intapi/antifrod/page_owner_report")).andExpect(status().isForbidden());
    }

}
