package ru.yandex.partner.intapi.configuration;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

import org.springframework.boot.test.autoconfigure.web.servlet.AutoConfigureMockMvc;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.transaction.annotation.Transactional;

import ru.yandex.partner.intapi.App;
import ru.yandex.partner.test.db.MysqlTestConfiguration;


@Target(ElementType.TYPE)
@Retention(RetentionPolicy.RUNTIME)
@SpringBootTest(
        properties = "spring.main.allow-bean-definition-overriding=true",
        classes = {App.class, MysqlTestConfiguration.class}
)
@AutoConfigureMockMvc
@Transactional
public @interface IntapiTest {
}
