#!/bin/bash -e

APP_ROOT=${1:-/app/java/jsonapi}

# Нужен для teamcity, так как teamcity себе ставит восьмую джаву
# (как зависимый покет от teamcity-agent->teamcity-common->yandex-jdk8)
# Не будем этому препятствовать, поставим рядом 17ю и будем на нее ссылаться при старте приложения
${JAVA_PROGRAM_PATH:-/usr/bin/java} -cp "$APP_ROOT/lib/*:" \
    -Djava.library.path="$APP_ROOT/lib/" \
    -Dspring.profiles.active=$JSONAPI_PROFILE \
    -Dserver.port=${JSONAPI_SERVER_PORT} \
    -Dmanagement.server.port=${JSONAPI_MANAGEMENT_PORT:-9790} \
    -Dspring.pid.file=${JSONAPI_PID_FILE:-/var/run/jsonapi.pid} \
    -Dlogging.filepath=${JSONAPI_LOG_FILE:-./java-dev.log} \
    -Dlogging.level.root=${JSONAPI_LOG_LEVEL:-INFO} \
    ${JAVA_OPTS} \
    -Xmx4g \
    ru.yandex.partner.jsonapi.App \
    $@
