#!/bin/bash -e

export JSONAPI_PROFILE=dev
export JSONAPI_PORT=8080
export JSONAPI_DEBUG_PORT=5005
export JSONAPI_MANAGEMENT_PORT=9790

export MYSQL_HOST=`perl -E 'use Partner::DB; print Partner::DB::get_db_partner2(server => dev)->{host};'`
export MYSQL_PORT=`perl -E 'use Partner::DB; print Partner::DB::get_db_partner2(server => dev)->{port};'`
export MYSQL_USER=`perl -E 'use Partner::DB; print Partner::DB::get_db_partner2(server => dev)->{user};'`
export MYSQL_PASSWORD=`perl -E 'use Partner::DB; print Partner::DB::get_db_partner2(server => dev)->{password};'`

export API_KEY_TOKEN=`jq -r .[\"apikey-token\"] /etc/pi-secrets.json`
export SECRET_YT_TOKEN=`jq -r .[\"yt-token\"] /etc/pi-secrets.json`

export DEPLOY_TVM_TOOL_URL=http://localhost:18080
export TVMTOOL_LOCAL_AUTHTOKEN=`cat /var/lib/tvmtool/local.auth`

ya tool java17 -cp "./yandex-partner-java-jsonapi/*:" \
    -Djava.library.path="./yandex-partner-java-jsonapi/" \
    -agentlib:jdwp=transport=dt_socket,server=y,suspend=n,address=*:$JSONAPI_DEBUG_PORT \
    ru.yandex.partner.jsonapi.App \
    --spring.profiles.active=$JSONAPI_PROFILE \
    --server.port=$JSONAPI_PORT \
    --management.server.port=$JSONAPI_MANAGEMENT_PORT \
    --logging.level.root=INFO
