package ru.yandex.partner.jsonapi;

import io.crnk.spring.setup.boot.monitor.CrnkSpringActuatorMetricsAutoConfiguration;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.actuate.autoconfigure.jdbc.DataSourceHealthContributorAutoConfiguration;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.context.ApplicationPidFileWriter;
import org.springframework.retry.annotation.EnableRetry;

@EnableRetry
@SpringBootApplication(exclude = {CrnkSpringActuatorMetricsAutoConfiguration.class,
        DataSourceHealthContributorAutoConfiguration.class})
@SuppressWarnings("HideUtilityClassConstructor")
public class App {
    public static void main(String[] args) {
        SpringApplication app = new SpringApplication(App.class);
        app.addListeners(new ApplicationPidFileWriter());
        app.run(args);
    }
}
