package ru.yandex.partner.jsonapi.configuration;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.partner.defaultconfiguration.rpc.DefaultRpcConfig;
import ru.yandex.partner.libs.extservice.balance.BalanceService;
import ru.yandex.partner.libs.extservice.balance.BalanceXmlRpcConfig;
import ru.yandex.partner.libs.extservice.balance.SimpleBalanceService;

@Configuration
public class BalanceConfiguration {

    @Bean
    public BalanceXmlRpcConfig balanceXmlRpcConfig(DefaultRpcConfig defaultRpcConfig) {
        return new BalanceXmlRpcConfig(defaultRpcConfig);
    }

    @Bean
    public BalanceService balanceService(BalanceXmlRpcConfig rpcConfig) {
        return new SimpleBalanceService(rpcConfig);
    }
}
