package ru.yandex.partner.jsonapi.configuration;

import javax.servlet.DispatcherType;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.partner.jsonapi.crnk.CustomCrnkFilter;

@Configuration
public class FilterConfiguration {

    @Bean
    public FilterRegistrationBean<CustomCrnkFilter> customCrnkFilterRegistration(
            @Autowired CustomCrnkFilter crnkCustomFilter
    ) {
        FilterRegistrationBean<CustomCrnkFilter> registration = new FilterRegistrationBean<>(crnkCustomFilter);
        registration.setDispatcherTypes(DispatcherType.REQUEST, DispatcherType.FORWARD);
        return registration;
    }

}
