package ru.yandex.partner.jsonapi.configuration;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.MessageSource;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.partner.libs.i18n.GettextMessageSource;
import ru.yandex.partner.libs.i18n.RawMessageSource;

@Configuration
public class I18nConfiguration {

    @Bean
    public MessageSource messageSource(@Value("${locale.disable:false}") boolean isLocaleDisabled) {
        return isLocaleDisabled ? new RawMessageSource() : new GettextMessageSource("translations");
    }

}
