package ru.yandex.partner.jsonapi.controller;

import java.io.IOException;

import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import io.crnk.core.boot.CrnkBoot;
import io.crnk.core.engine.http.HttpRequestContext;
import io.crnk.servlet.CrnkFilter;
import io.crnk.servlet.internal.ServletRequestContext;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

import ru.yandex.partner.jsonapi.crnk.DynamicModule;
import ru.yandex.partner.jsonapi.crnk.exceptions.CrnkResponseStatusException;

@RestController
public class ActionsController {
    private static final Logger LOGGER = LoggerFactory.getLogger(ActionsController.class);

    private final DynamicModule dynamicModule;
    private final String webPathPrefix;
    private final String defaultCharacterEncoding;
    private final ServletConfig servletConfig;

    @Autowired
    private ActionsController(DynamicModule dynamicModule,
                              CrnkFilter crnkFilter,
                              CrnkBoot crnkBoot,
                              ServletConfig servletConfig) {
        this.dynamicModule = dynamicModule;
        this.webPathPrefix = crnkBoot.getWebPathPrefix();
        this.defaultCharacterEncoding = crnkFilter.getDefaultCharacterEncoding();
        this.servletConfig = servletConfig;
    }


    @PostMapping(value = "/v1/{resourceType}/{id}/action/{actionName}")
    public Object doAction(
            HttpServletRequest request,
            HttpServletResponse response,
            @PathVariable String resourceType,
            @PathVariable String id,
            @PathVariable String actionName) {

        var repository = dynamicModule.getDynamicResourceRepository(resourceType);

        if (repository == null) {
            throw new ResponseStatusException(HttpStatus.NOT_FOUND);
        }

        ServletRequestContext context = new ServletRequestContext(servletConfig.getServletContext(), request,
                response, webPathPrefix, defaultCharacterEncoding);
        response.setContentType("application/vnd.api+json");
        response.setCharacterEncoding(defaultCharacterEncoding);
        try {
            return repository.doAction(id,
                    actionName,
                    IOUtils.toString(request.getInputStream()),
                    HttpRequestContext.create(context));
        } catch (CrnkResponseStatusException e) {
            throw e;
        } catch (IOException e) {
            LOGGER.error("IOException during action {} on resource {} {}", actionName, resourceType, id, e);
            throw new ResponseStatusException(HttpStatus.INTERNAL_SERVER_ERROR, "Error while reading request body", e);
        } catch (Exception e) {
            LOGGER.error("Exception during action {} on resource {} {}", actionName, resourceType, id, e);
            throw new ResponseStatusException(HttpStatus.INTERNAL_SERVER_ERROR, e.getMessage(), e);
        }
    }
}
