package ru.yandex.partner.jsonapi.controller;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import ru.yandex.partner.jsonapi.service.CommonResponseService;
import ru.yandex.partner.jsonapi.service.CrnkAdditionalDataService;

@RestController
public class AddFieldsController {

    private final CrnkAdditionalDataService crnkAdditionalDataService;
    private final CommonResponseService commonResponseService;

    @Autowired
    private AddFieldsController(CrnkAdditionalDataService crnkAdditionalDataService,
                                CommonResponseService commonResponseService) {
        this.crnkAdditionalDataService = crnkAdditionalDataService;
        this.commonResponseService = commonResponseService;
    }

    @GetMapping(value = "/v1/{resourceType}/add_fields")
    public Object getAddFields(
            HttpServletRequest request,
            HttpServletResponse response,
            @PathVariable String resourceType,
            @RequestParam(required = false) String attributes
    ) {
        var result = commonResponseService.commonResponse(request, response, resourceType);

        return crnkAdditionalDataService.getAddFields(result.getFirst(), attributes, result.getSecond());
    }
}
