package ru.yandex.partner.jsonapi.controller

import java.io.BufferedReader
import java.io.IOException
import java.io.InputStreamReader

import org.springframework.beans.factory.annotation.Value
import org.springframework.core.io.FileSystemResource
import org.springframework.http.HttpStatus
import org.springframework.http.MediaType
import org.springframework.web.bind.annotation.GetMapping
import org.springframework.web.bind.annotation.RestController
import org.springframework.web.server.ResponseStatusException

@RestController
class AppVersionController {

    @GetMapping(value = [PATH], produces = [MediaType.APPLICATION_JSON_VALUE])
    fun version(@Value("\${version-path}") pathToVersion: String): Any {
        val versionResource = FileSystemResource(pathToVersion)
        try {
            versionResource.inputStream.use { `in` ->
                val version = BufferedReader(InputStreamReader(`in`)).readLine()
                return mapOf("data" to version)
            }
        } catch (e: IOException) {
            throw ResponseStatusException(HttpStatus.NOT_FOUND, "No version file!")
        }
    }

    companion object {
        const val PATH = "java/version"
    }
}
