package ru.yandex.partner.jsonapi.controller

import com.fasterxml.jackson.databind.ObjectMapper
import io.crnk.core.engine.document.Document
import io.crnk.core.utils.Nullable
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.web.bind.annotation.GetMapping
import org.springframework.web.bind.annotation.PathVariable
import org.springframework.web.bind.annotation.RestController
import ru.yandex.partner.jsonapi.crnk.BaseCrnkLinksInformation
import ru.yandex.partner.jsonapi.service.ApiBkDataService
import ru.yandex.partner.jsonapi.service.CommonResponseService
import ru.yandex.partner.libs.auth.annotation.Auth
import ru.yandex.partner.libs.auth.annotation.AuthenticationType
import javax.servlet.http.HttpServletRequest
import javax.servlet.http.HttpServletResponse

@RestController
class BkDataController @Autowired constructor(
    private val apiBkDataService: ApiBkDataService,
    private val objectMapper: ObjectMapper,
    private val commonResponseService: CommonResponseService
) {

    @Auth(AuthenticationType.TVM)
    @GetMapping("/v1/bkdata/{pk}")
    fun getBkData(servletRequest: HttpServletRequest,
        servletResponse: HttpServletResponse,
        @PathVariable pk: String): Document {
        val bkData = apiBkDataService.getBkData(pk)
        val response = Document()
        response.data = Nullable.of(bkData)
        val linksInformation = BaseCrnkLinksInformation()
        linksInformation.setSelf(commonResponseService.getRequestContext(servletRequest, servletResponse).baseUrl +
            "/bkdata/${pk}")

        response.links = objectMapper.valueToTree(linksInformation)

        return response
    }

}
