package ru.yandex.partner.jsonapi.controller;

import java.io.IOException;

import javax.servlet.http.HttpServletRequest;

import NPartner.Page.TPartnerPage;
import org.apache.commons.io.IOUtils;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

import ru.yandex.partner.core.bs.BkDataException;
import ru.yandex.partner.core.bs.enrich.BkDataService;
import ru.yandex.partner.libs.auth.annotation.Auth;
import ru.yandex.partner.libs.auth.annotation.AuthenticationType;

@RestController
public class BkDataEnrichPageController {

    private final BkDataService bkDataService;

    public BkDataEnrichPageController(
            BkDataService bkDataService
    ) {
        this.bkDataService = bkDataService;
    }

    @Auth(AuthenticationType.TVM)
    @PostMapping("/v1/api/bkdata/enrich_page")
    public String enrichPage(
            HttpServletRequest request,
            @RequestParam(name = "read_only", required = false, defaultValue = "1") boolean readOnly
    ) throws IOException {
        String pageBkData = IOUtils.toString(request.getReader());
        try {
            TPartnerPage page = bkDataService.enrichPage(pageBkData, readOnly);
            return bkDataService.convertToJson(page);
        } catch (BkDataException enrichEx) {
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, enrichEx.getMessage(), enrichEx);
        }
    }

    @Auth(AuthenticationType.TVM)
    @PostMapping("/v1/api/bkdata/bk_page_update")
    public String bkPageUpdate(
            HttpServletRequest request,
            @RequestParam(name = "read_only", required = false, defaultValue = "1") boolean readOnly
    ) throws IOException {
        String pageBkData = IOUtils.toString(request.getReader());
        try {
            TPartnerPage page = bkDataService.enrichPage(pageBkData, readOnly);
            bkDataService.send(page);
            return bkDataService.convertToJson(page);
        } catch (BkDataException e) {
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, e.getMessage(), e);
        }
    }
}
